/*****************************************************************************
*  LPC154x SCT0 Match toggle for LPCXpresso board
*
*  1. Use SCT0 timer to generate a 50 msec clock output @ SCT0_OUT0
*  2. SCT0_OUT0 is linked to P0_25 (toggles every 50 msec)
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT0_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/
void SCT0_Init(void)
{

	Chip_SCT_Init(LPC_SCT0);                								               // enable the SCT0 clock

	Chip_SCT_Config(LPC_SCT0, 	SCT_CONFIG_16BIT_COUNTER 	|
                              SCT_CONFIG_AUTOLIMIT_L 		);				       // two 16 bit timers, auto limit

	Chip_SCT_SetControl(LPC_SCT0, SCT_CTRL_PRE_L(119));					           // PRE_L[12:5] = 120-1 (SCT clock = 12MHz/120 = 100 KHz)

	Chip_SCT_SetMatchCount(LPC_SCT0, SCT_MATCH_0, (100000/10)-1);						        // match 0 @ 10 Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT0, SCT_MATCH_0, (100000/10)-1);

	Chip_SCT_EventState(LPC_SCT0, SCT_EVENT_0 , ENABLE_ALL_STATES);			  // event 0 happens in all state
	Chip_SCT_EventControl(LPC_SCT0, SCT_EVENT_0 , SCT_COMBMODE_MATCH);		// match 0 condition only

	Chip_SCT_SetOutput(LPC_SCT0, SCT_OUTPUT_0 , SCT_EVT_0);					      // event 0 will set   SCT0_OUT0
	Chip_SCT_ClearOutput(LPC_SCT0, SCT_OUTPUT_0, SCT_EVT_0);				      // event 0 will clear SCT0_OUT0

	Chip_SCT_SetConflictResolution(LPC_SCT0, 0 ,SCT_RES_TOGGLE_OUTPUT);		// output 0 toggles on conflict

	Chip_SCT_ClearControl(LPC_SCT0,SCT_CTRL_HALT_L);               			  // start timer
}


int main(void)
{
	SystemCoreClockUpdate();
  	Board_Init();

  	Chip_Clock_SetSysClockDiv(6);

  	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);							        //enable SWM clk

    Chip_SWM_MovablePortPinAssign(SWM_SCT0_OUT0_O , 0, 25); 				    // P0_25 (red LED) is SCT0_OUT0

    SCT0_Init();                                           			       	// Initialize SCT0

    while (1)                                              					    // loop forever
    {
    	__WFI();
    }
}
